//
//  Controller.m
//  A to G (formerly AddressBookToCSV)
//
//  Created by Ken Ferry on Thu Jun 17 2004.
//  Copyright (c) 2006 Ben Borofka. All rights reserved.
//

#import "Controller.h"

#import <AddressBook/AddressBook.h>
#import "ABPerson+CSVExport.h"
#import "ABMultiValue+CSVExport.h"

@implementation Controller

- (IBAction)exportAddressBook:(id)sender
{
    NSSavePanel *savePanel = [NSSavePanel savePanel]; // NSSavePanel is 10.3
    
    [savePanel beginSheetForDirectory:NSHomeDirectory()
                                 file:@"contacts.csv"
                       modalForWindow:[self window]
                        modalDelegate:self
                       didEndSelector:@selector(savePanelDidEnd:returnCode:contextInfo:) 
                          contextInfo:nil];
}

- (void)savePanelDidEnd:(NSSavePanel *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
    if (returnCode == NSOKButton)
    {
        [self exportAddressBookToFile:[sheet filename]];
    }
}


- (BOOL)exportAddressBookToFile:(NSString *)path
{
    NSData *csvDatabase = [self csvFormatAddressBook];
    
    return [csvDatabase writeToFile:path atomically:YES];
}

- (NSData *)csvFormatAddressBook
{
    NSEnumerator *allPeopleEnumerator = [[[ABAddressBook sharedAddressBook] people] objectEnumerator];
    return [self csvFormatDatabaseForPersonEnumerator:allPeopleEnumerator];
}

// testing only
- (NSData *)csvFormatDatabaseForTestGroup
{
    ABSearchElement *encodeTestSearchEl;
    ABGroup *encodeTestGroup;
    
    encodeTestSearchEl = [ABGroup searchElementForProperty:kABGroupNameProperty
                                                     label:nil 
                                                       key:nil 
                                                     value:@"Encode Test Group" 
                                                comparison:kABEqual];
    
    encodeTestGroup = [[[ABAddressBook sharedAddressBook] recordsMatchingSearchElement:encodeTestSearchEl] objectAtIndex:0];
    NSEnumerator *testPeopleEnumerator = [[encodeTestGroup members] objectEnumerator];
    
    return [self csvFormatDatabaseForPersonEnumerator:testPeopleEnumerator];
}

- (NSData *)csvFormatDatabaseForPersonEnumerator:(NSEnumerator *)personEnumerator
{
    NSMutableString *csvString;
    NSEnumerator *emailEnumerator;
    ABPerson *person;
    
	// Put at the top of the .csv file
    csvString = [NSMutableString stringWithString:@"Name, E-mail, Notes, Section 1 - Description, Section 1 - Email, Section 1 - IM, Section 1 - Phone, Section 1 - Mobile, Section 1 - Pager, Section 1 - Fax, Section 1 - Company, Section 1 - Title, Section 1 - Other, Section 1 - Address, Section 2 - Description, Section 2 - Email, Section 2 - IM, Section 2 - Phone, Section 2 - Mobile, Section 2 - Pager, Section 2 - Fax, Section 2 - Company, Section 2 - Title, Section 2 - Other, Section 2 - Address\n"];

    while (person = [personEnumerator nextObject])	// Iterate through all the contacts
    {        
        BOOL isCompany = [person isCompany];
        emailEnumerator = [[[person valueForProperty:kABEmailProperty] allValues] objectEnumerator];
        
        if ([person primaryEmail])	// If the contact has an email entry
        {
            if (isCompany)	// It's a company
            {
                [csvString appendString:[NSString stringWithFormat:@"\"%@\",%@,\"%@\",%@,%@,%@,%@,%@,%@,%@,%@,%@,%@,\"%@\",%@,%@,%@,%@,%@,%@,%@,%@,%@,%@,\"%@\"\n", 
					[person valueForProperty:kABOrganizationProperty], [person primaryEmail], [person valueForProperty:kABNoteProperty], @"Home", [person homeEmail], [person homeIM], [person homePhone], [person mobilePhone], [person pagerPhone], [person homeFax], nil, [person valueForProperty:kABJobTitleProperty], nil, [person homeAddress], @"Work", [person workEmail], [person workIM], [person workPhone], nil, nil, [person workFax], [person valueForProperty:kABOrganizationProperty], nil, nil, [person workAddress]]];
            }
            else	// It's a person
            {
                [csvString appendString:[NSString stringWithFormat:@"\"%@\",%@,\"%@\",%@,%@,%@,%@,%@,%@,%@,%@,%@,%@,\"%@\",%@,%@,%@,%@,%@,%@,%@,%@,%@,%@,\"%@\"\n",
					[person fullName],  [person primaryEmail], [person valueForProperty:kABNoteProperty], @"Home", [person homeEmail], [person homeIM], [person homePhone], [person mobilePhone], [person pagerPhone], [person homeFax], nil, [person valueForProperty:kABJobTitleProperty], nil, [person homeAddress], @"Work", [person workEmail], [person workIM], [person workPhone], nil, nil, [person workFax], [person valueForProperty:kABOrganizationProperty], nil, nil, [person workAddress]]];

            }
        }
    }
    
    [csvString replaceOccurrencesOfString:@"(null)" 
                               withString:@"" 
                                  options:NSLiteralSearch 
                                    range:NSMakeRange(0, [csvString length])]; 
    
    return [csvString dataUsingEncoding:CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingISOLatin1) allowLossyConversion:YES];
}

@end
